Rem
Rem $Header: jms_enq.sql 11-jul-2003.15:48:37 kbittler Exp $
Rem
Rem jms_enq.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      jms_enq.sql - Creates and enqeues a JMS message.
Rem
Rem    DESCRIPTION
Rem      This script creates a message with payload type
Rem      SYS.AQ$_JMS_TEXT_MESSAGE and enqueues it to the queue
Rem      MGWUSER.JMS_TEXTQ.
Rem
Rem    NOTES
Rem

DECLARE 
  message            sys.aq$_jms_text_message; 
  enqueue_options    dbms_aq.enqueue_options_t; 
  message_properties dbms_aq.message_properties_t; 
  msgid              raw(16); 
BEGIN 
  message := sys.aq$_jms_text_message.construct; 
  message.set_text('sample JMS text message'); 

  dbms_aq.enqueue(queue_name => 'mgwuser.jms_textq', 
                  enqueue_options => enqueue_options, 
                  message_properties => message_properties, 
                  payload => message, 
                  msgid => msgid); 
  commit;
END; 
/
